<?php declare(strict_types=1);
if (!defined('MW_PATH')) {
    exit('No direct script access allowed');
}

/**
 * EmailHelper
 *
 * @package MailWizz EMA
 * @author MailWizz Development Team <support@mailwizz.com>
 * @link https://www.mailwizz.com/
 * @copyright MailWizz EMA (https://www.mailwizz.com)
 * @license https://www.mailwizz.com/license/
 * @since 2.0.29
 */

class EmailHelper
{
    /**
     * @param string $email
     * @return string
     */
    public static function getDomainFromEmail(string $email): string
    {
        if (!FilterVarHelper::email($email)) {
            return '';
        }
        $domain = explode('@', $email);
        return array_pop($domain);
    }

    /**
     * @param Lists $list
     *
     * @return string
     */
    public static function getListIDHeaderValue(Lists $list): string
    {
        /** @var OptionUrl $optionUrl */
        $optionUrl = container()->get(OptionUrl::class);

        $identifier = $list->list_uid;
        if (
            $optionUrl->getFrontendUrl() &&
            ($domain = parse_url($optionUrl->getFrontendUrl(), PHP_URL_HOST))
        ) {
            $identifier = sprintf('%s.list-id.%s', $list->list_uid, $domain);
        }

        $value = sprintf('%s <%s>', StringHelper::truncateLength($list->display_name, 50), $identifier);

        return (string) hooks()->applyFilters('email_helper_get_list_id_header_value', $value, $list);
    }
}
