<?php declare(strict_types=1);
if (!defined('MW_PATH')) {
    exit('No direct script access allowed');
}

/**
 * SurveyFieldHeading
 *
 * @package MailWizz EMA
 * @author MailWizz Development Team <support@mailwizz.com>
 * @link https://www.mailwizz.com/
 * @copyright MailWizz EMA (https://www.mailwizz.com)
 * @license https://www.mailwizz.com/license/
 * @since 1.7.8
 */

/**
 * Class SurveyFieldHeading
 */
class SurveyFieldHeading extends SurveyField
{
    /**
     * @var string
     */
    public $heading_type = 'h1';

    /**
     * @var string
     */
    public $top_divider = self::TEXT_NO;

    /**
     * @var string
     */
    public $bottom_divider = self::TEXT_NO;

    /**
     * @return array
     */
    public function rules()
    {
        $rules = [
            ['heading_type', 'required'],
            ['heading_type', 'in', 'range' => array_keys($this->getHeadingTypeOptionsArray())],
            ['top_divider, bottom_divider', 'in', 'range' => array_keys($this->getYesNoOptions())],
        ];

        return CMap::mergeArray($rules, parent::rules());
    }

    /**
     * @return array
     */
    public function attributeLabels()
    {
        $labels = [
            'label'         => t('survey_fields', 'Heading text'),
            'heading_type'  => t('survey_fields', 'Heading type'),
            'top_divider'   => t('survey_fields', 'Top divider'),
            'bottom_divider' => t('survey_fields', 'Bottom divider'),
        ];

        return CMap::mergeArray(parent::attributeLabels(), $labels);
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return SurveyFieldHeading the static model class
     */
    public static function model($className=self::class)
    {
        /** @var SurveyFieldHeading $parent */
        $parent = parent::model($className);

        return $parent;
    }

    /**
     * @return array
     */
    public function attributeHelpTexts()
    {
        $texts = [
            'label' => t('survey_fields', 'The heading text shown to the responder.'),
            'top_divider' => t('survey_fields', 'Whether to add a divider before the heading text.'),
            'bottom_divider' => t('survey_fields', 'Whether to add a divider after the heading text.'),
        ];

        return CMap::mergeArray(parent::attributeHelpTexts(), $texts);
    }

    /**
     * @return string[]
     */
    public function getHeadingTypeOptionsArray(): array
    {
        return [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
        ];
    }

    /**
     * @return void
     */
    protected function afterConstruct()
    {
        $this->required = self::TEXT_NO;
        $this->help_text = '';
        parent::afterConstruct();
    }

    /**
     * @return bool
     */
    protected function beforeSave()
    {
        $this->modelMetaData->getModelMetaData()->add('heading_type', (string)$this->heading_type);
        $this->modelMetaData->getModelMetaData()->add('top_divider', (string)$this->top_divider);
        $this->modelMetaData->getModelMetaData()->add('bottom_divider', (string)$this->bottom_divider);
        return parent::beforeSave();
    }

    /**
     * @return void
     */
    protected function afterFind()
    {
        $this->heading_type = (string)$this->modelMetaData->getModelMetaData()->itemAt('heading_type');
        $this->top_divider = (string)$this->modelMetaData->getModelMetaData()->itemAt('top_divider');
        $this->bottom_divider = (string)$this->modelMetaData->getModelMetaData()->itemAt('bottom_divider');
        parent::afterFind();
    }
}
