<?php declare(strict_types=1);
if (!defined('MW_PATH')) {
    exit('No direct script access allowed');
}

/**
 * This file is part of the MailWizz EMA application.
 *
 * @package MailWizz EMA
 * @author MailWizz Development Team <support@mailwizz.com>
 * @link https://www.mailwizz.com/
 * @copyright MailWizz EMA (https://www.mailwizz.com)
 * @license https://www.mailwizz.com/license/
 * @since 2.7.5
 */

?>

<div class="form-group field-<?php echo $field->type->identifier; ?> wrap-<?php echo strtolower((string)$field->getTag()); ?>" style="display: <?php echo !empty($visible) ? 'block' : 'none'; ?>">
    <?php if ($field->top_divider === SurveyFieldHeading::TEXT_YES) {
    echo CHtml::tag('hr', [
            'class' => sprintf('field-%s-top-divider', $field->type->identifier),
        ], false, false);
} ?>

    <?php echo CHtml::tag($field->heading_type, [], html_encode($field->label)); ?>

    <?php if ($field->bottom_divider === SurveyFieldHeading::TEXT_YES) {
    echo CHtml::tag('hr', [
            'class' => sprintf('field-%s-bottom-divider', $field->type->identifier),
        ], false, false);
} ?>
</div>