<?php
/*
 * PepipostLib
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace PepipostLib\Models;

use JsonSerializable;

/**
 *Master modal
 */
class Send implements JsonSerializable
{
    /**
     * email address which recipients can reply to.
     * @maps reply_to
     * @var string|null $replyTo public property
     */
    public $replyTo;

    /**
     * email address representing the sender of the mail
     * @required
     * @var \PepipostLib\Models\From $from public property
     */
    public $from;

    /**
     * Subject line of the email
     * @required
     * @var string $subject public property
     */
    public $subject;

    /**
     * ID of the template to be used for sending the mail
     * @maps template_id
     * @var integer|null $templateId public property
     */
    public $templateId;

    /**
     * content in text/plain format
     * @required
     * @var \PepipostLib\Models\Content[] $content public property
     */
    public $content;

    /**
     * attachment information
     * @var \PepipostLib\Models\Attachments[]|null $attachments public property
     */
    public $attachments;

    /**
     * to recipient with some personalized data like to address, attachments and attributes
     * @required
     * @var \PepipostLib\Models\Personalizations[] $personalizations public property
     */
    public $personalizations;

    /**
     * Enable/Disable settings like click, open and unsubscribe track
     * @var \PepipostLib\Models\Settings|null $settings public property
     */
    public $settings;

    /**
     * define custom tags to organize your emails
     * @var array|null $tags public property
     */
    public $tags;

    /**
     * @todo Write general description for this property
     * @maps lint_payload
     * @var bool|null $lintPayload public property
     */
    public $lintPayload;

    /**
     * schedule the time of email delivery
     * @var integer|null $schedule public property
     */
    public $schedule;

    /**
     * Global bcc can be defined here
     * @var \PepipostLib\Models\EmailStruct[]|null $bcc public property
     */
    public $bcc;

    /**
     * Constructor to set initial or default values of member properties
     * @param string   $replyTo          Initialization value for $this->replyTo
     * @param From     $from             Initialization value for $this->from
     * @param string   $subject          Initialization value for $this->subject
     * @param integer  $templateId       Initialization value for $this->templateId
     * @param array    $content          Initialization value for $this->content
     * @param array    $attachments      Initialization value for $this->attachments
     * @param array    $personalizations Initialization value for $this->personalizations
     * @param Settings $settings         Initialization value for $this->settings
     * @param array    $tags             Initialization value for $this->tags
     * @param bool     $lintPayload      Initialization value for $this->lintPayload
     * @param integer  $schedule         Initialization value for $this->schedule
     * @param array    $bcc              Initialization value for $this->bcc
     */
    public function __construct()
    {
        if (12 == func_num_args()) {
            $this->replyTo          = func_get_arg(0);
            $this->from             = func_get_arg(1);
            $this->subject          = utf8_encode(func_get_arg(2));
            $this->templateId       = func_get_arg(3);
            $this->content          = func_get_arg(4);
            $this->attachments      = func_get_arg(5);
            $this->personalizations = func_get_arg(6);
            $this->settings         = func_get_arg(7);
            $this->tags             = func_get_arg(8);
            $this->lintPayload      = func_get_arg(9);
            $this->schedule         = func_get_arg(10);
            $this->bcc              = func_get_arg(11);
        }
    }


    /**
     * Encode this object to JSON
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        $json = array();
        $json['reply_to']         = $this->replyTo;
        $json['from']             = $this->from;
        $json['subject']          = $this->subject;
        $json['template_id']      = $this->templateId;
        $json['content']          = $this->content;
        $json['attachments']      = $this->attachments;
        $json['personalizations'] = $this->personalizations;
        $json['settings']         = $this->settings;
        $json['tags']             = $this->tags;
        $json['lint_payload']     = $this->lintPayload;
        $json['schedule']         = $this->schedule;
        $json['bcc']              = $this->bcc;

        return $json;
    }
}
