<?php

/**
 * Copyright (c) 2022-present Tectalic (https://tectalic.com)
 *
 * For copyright and license information, please view the LICENSE file that was distributed with this source code.
 *
 * Please see the README.md file for usage instructions.
 */

declare(strict_types=1);

namespace Tectalic\OpenAi\Models\ChatCompletions;

use Tectalic\OpenAi\Models\AbstractModel;

final class CreateRequestMessagesItem extends AbstractModel
{
    /**
     * List of required property names.
     *
     * These properties must all be set when this Model is instantiated.
     */
    protected const REQUIRED = ['role', 'content'];

    /**
     * The role of the messages author. One of system, user, assistant, or function.
     *
     * Allowed values: 'system', 'user', 'assistant', 'function'
     *
     * @var string
     */
    public $role;

    /**
     * The contents of the message. content is required for all messages, and may be
     * null for assistant messages with function calls.
     *
     * @var string|null
     */
    public $content;

    /**
     * The name of the author of this message. name is required if role is function,
     * and it should be the name of the function whose response is in the content. May
     * contain a-z, A-Z, 0-9, and underscores, with a maximum length of 64 characters.
     *
     * @var string
     */
    public $name;

    /**
     * The name and arguments of a function that should be called, as generated by the
     * model.
     *
     * @var \Tectalic\OpenAi\Models\ChatCompletions\CreateRequestMessagesItemFunctionCall
     */
    public $function_call;
}
